<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page-master" page-height="29.5cm" page-width="21cm" margin-top="1cm" margin-bottom="1cm" margin-left="2.5cm" margin-right="2.5cm">
				<fo:region-before margin-right="2.5cm" extent="2.5cm"/>
				<fo:region-body margin-top="3.85cm" margin-bottom="1.35cm" font-family="Helvetica,Times,Courier" font-size="14pt" line-height="16pt"/>
				<fo:region-after extent="0.75cm"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			
			
	<!-- 
	Sacado el for-each que se repite, el de cartas -> mediador, fuera del page-sequence, y así funciona correctamente.
	Se genera un page-sequence por cada mediador, y así se necesita menos memoria.
	Parece que el page-sequence mete el salto de página, por lo que he quitado el break que se utilizaba cuando solo había una page-sequence
	 -->	
	<xsl:for-each select="cartas">
		<xsl:for-each select="mediador">
			<fo:page-sequence master-reference="default-page-master">
				<fo:static-content flow-name="xsl-region-before">
					<fo:table table-layout="fixed">
						<fo:table-column column-width="1cm"/>
						<fo:table-column column-width="14cm"/>
						<fo:table-column column-width="1cm"/>
						<fo:table-body display-align="center">
							<fo:table-row>
								<fo:table-cell border="0pt solid black">
									<fo:block/>
								</fo:table-cell>
								<fo:table-cell border="0pt solid black">
									<fo:block font-size="11pt" color="#000000" text-align="center">
										<fo:external-graphic src="url(/datos/p06b/file/images/logoActual.jpg)" scaling="non-uniform" alignment-adjust="0%" width="11.5cm" height="1.9cm"/>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell border="0pt solid black">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:static-content>
				<fo:static-content flow-name="xsl-region-after">
					<fo:table border="0pt solid black" table-layout="fixed">
						<fo:table-column column-width="16cm"/>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="center">
									<fo:block line-height="10pt" font-size="7pt" space-before.optimum="1.5pt" space-after.optimum="1.5pt" keep-together="always">
										Donostia-San Sebastián, 1 – 01010 Vitoria-Gasteiz – Tef. 945 01 90 19 – Fax 945 01 90 20
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:static-content>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<!-- xsl:for-each select="cartas"-->
							<!-- xsl:for-each select="mediador"-->
								<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
									<fo:table-column column-width="9cm"/>
									<fo:table-column column-width="7cm"/>
									<fo:table-body>
										<fo:table-row>
											<fo:table-cell font-size="8pt" padding-after="0pt" padding-before="0pt" width="9cm" padding-start="3pt" padding-end="3pt">
												<fo:block/>
											</fo:table-cell>
											<fo:table-cell font-size="8pt" padding-after="2pt" padding-before="0pt" text-align="left" width="7cm" padding-start="3pt" padding-end="3pt">
												<fo:block>
													<xsl:for-each select="denominacion">
														<xsl:apply-templates/>
													</xsl:for-each>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-size="8pt" padding-after="2pt" padding-before="0pt" text-align="left" width="9cm" padding-start="3pt" padding-end="3pt">
												<fo:block/>
											</fo:table-cell>
											<fo:table-cell font-size="8pt" padding-after="2pt" padding-before="0pt" text-align="left" width="7cm" padding-start="3pt" padding-end="3pt">
												<fo:block>
													<xsl:for-each select="direccion">
														<xsl:apply-templates/>
													</xsl:for-each>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-size="8pt" padding-after="2pt" padding-before="0pt" text-align="left" width="9cm" padding-start="3pt" padding-end="3pt">
												<fo:block/>
											</fo:table-cell>
											<fo:table-cell font-size="8pt" padding-after="2pt" padding-before="0pt" text-align="left" width="7cm" padding-start="3pt" padding-end="3pt">
												<fo:block>
													<xsl:for-each select="codPostal">
														<xsl:apply-templates/>
													</xsl:for-each>&#160;<xsl:for-each select="municipio">
														<xsl:apply-templates/>
													</xsl:for-each>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-size="8pt" padding-after="2pt" padding-before="0pt" text-align="left" width="9cm" padding-start="3pt" padding-end="3pt">
												<fo:block/>
											</fo:table-cell>
											<fo:table-cell font-size="8pt" padding-after="2pt" padding-before="0pt" text-align="left" width="7cm" padding-start="3pt" padding-end="3pt">
												<fo:block>
													<xsl:for-each select="provincia">
														<xsl:apply-templates/>
													</xsl:for-each>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:block>
									<xsl:text>&#xA;</xsl:text>
								</fo:block>

								<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
									<fo:table-column column-width="8cm"/>
									<fo:table-column column-width="8cm"/>
									<fo:table-body>
										<fo:table-row>
											<fo:table-cell font-size="9pt" text-align="justify" width="8cm" padding-start="3pt" padding-end="6pt" padding-before="3pt" padding-after="3pt">
												<fo:block>
													Honen bitartez gogorarazten dizugu ezen, 26/2006 Legearen 49. artikuluan xedatutakoaren arabera, 
													<xsl:for-each select="/">
														<xsl:for-each select="cartas">
															<xsl:for-each select="ejerAnterior">
																<xsl:apply-templates/>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>(e)ko ekitaldiari dagozkion kontabilitateko dokumentu estatistikoak aurkeztu behar dituzuela Finantza Politikako eta Erakundeen Baliabideetako Zuzendaritza honetan.
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
												</fo:block>
											</fo:table-cell>
											
											<fo:table-cell font-size="9pt" text-align="justify" width="8cm" padding-start="6pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
												<fo:block>Por la presente le recordamos que, para dar cumplimiento a lo dispuesto en el artículo 49 de la Ley 26/2006, están obligados a presentar ante la Dirección de Política Financiera y Recursos Institucionales la documentación estadístico-contable correspondiente al ejercicio económico del <xsl:for-each select="/">
														<xsl:for-each select="cartas">
															<xsl:for-each select="ejerAnterior">
																<xsl:apply-templates/>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>.<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
												</fo:block>
											</fo:table-cell>
											
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-size="9pt" text-align="justify" width="8cm" padding-start="3pt" padding-end="6pt" padding-before="3pt" padding-after="3pt">
												<fo:block>
													Dakizuenez, horren obligazioa dute 
													<xsl:for-each select="/">
														<xsl:for-each select="cartas">
															<xsl:for-each select="ejerAnterior">
																<xsl:apply-templates/>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>(e)ko abenduaren 31n Aseguru-artekarien, berraseguru-artekarien eta bertako goi-kargudunen administrazio-erregistro berezian –Eusko Jaurlaritzako Ogasun eta Finantza Saileko Finantza Politikako eta Erakundeen Baliabideetako Zuzendaritzak kudeatzen duena– izena emanda ageri diren aseguru-artekariek, berraseguru-artekariek, aseguru-agente lotuek eta aseguru eta bankuen operadore lotuek.
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell font-size="9pt" text-align="justify" width="8cm" padding-start="6pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
												<fo:block>Como saben, están obligados a remitir la información estadístico-contable los corredores de seguros, los corredores de reaseguros, los agentes de seguros vinculados y los operadores de banca-seguros vinculados inscritos a fecha 31 de diciembre de <xsl:for-each select="/">
														<xsl:for-each select="cartas">
															<xsl:for-each select="ejerAnterior">
																<xsl:apply-templates/>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each> en el Registro administrativo especial de corredores de seguros y de reaseguros, sociedades de correduría de seguros y de reaseguros y sus altos cargos que lleva la Dirección de Política Financiera y Recursos Institucionales del Departamento de Hacienda y Finanzas del Gobierno Vasco.<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-size="9pt" text-align="justify" width="8cm" padding-start="3pt" padding-end="6pt" padding-before="3pt" padding-after="3pt">
												<fo:block>
													<xsl:for-each select="/">
														<fo:inline font-weight="bold">
															<xsl:for-each select="cartas">
																<xsl:for-each select="ejercicio">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</xsl:for-each>
														</fo:inline>
													</xsl:for-each>
													<fo:inline font-weight="bold">(e)ko apirilaren 30a</fo:inline> 
													baino lehenago bidali behar dira dokumentu horiek aurreko ekitaldiaren itxierari dagozkion datuekin. Kontabilitateko informazio estatistiko hori ez bidaltzea arau-haustetzat hartzen da eta, 26/2006 Legearen 55.2 q) artikuluan xedatutakoari jarraikiz, Erregistrotik ezabatzea ere ekar lezake berekin.
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
												</fo:block>
											</fo:table-cell>
											
											<fo:table-cell font-size="9pt" text-align="justify" width="8cm" padding-start="6pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
												<fo:block>La remisión deberá realizarse antes del <fo:inline font-weight="bold">30 de abril de </fo:inline>
													<xsl:for-each select="/">
														<fo:inline font-weight="bold">
															<xsl:for-each select="cartas">
																<xsl:for-each select="ejercicio">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</xsl:for-each>
														</fo:inline>
													</xsl:for-each> con los datos correspondientes al cierre del ejercicio anterior. La falta de remisión de esa información estadístico-contable se tipifica como infracción y puede suponer la cancelación de la inscripción en el Registro, a tenor de lo establecido en el artículo 55.2q) de la Ley 26/2006.
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-size="9pt" text-align="justify" width="8cm" padding-start="3pt" padding-end="6pt" padding-before="3pt" padding-after="3pt">
												<fo:block>
													EKD 
													<xsl:for-each select="/">
														<xsl:for-each select="cartas">
															<xsl:for-each select="ejerAnterior">
																<xsl:apply-templates/>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each> 
													betetzeko "EKD ASEGURU-ARTEKARIAK" aplikazioa erabili behar da, webgune honetan eskura daitekeena: <fo:inline color="#0000FF" text-decoration="underline">www.euskadi.eus</fo:inline>. Aplikazioan badira bete beharreko eremuak eta berez kalkulatzen direnak ere (batura, kendura eta portzentajeak), hartara ahalik eta akats gutxienak gerta daitezen.
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
												</fo:block>
											</fo:table-cell>
											
											<fo:table-cell font-size="9pt" text-align="justify" width="8cm" padding-start="6pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
												<fo:block>Para cumplimentar la DEC 
													<xsl:for-each select="/">
														<xsl:for-each select="cartas">
															<xsl:for-each select="ejerAnterior">
																<xsl:apply-templates/>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>, se deberá utilizar la aplicación "DEC MEDIADORES DE SEGUROS" que puede ser descargada desde la siguiente página web: 
													<fo:inline color="#0000FF"></fo:inline>
													<fo:inline color="#0000FF" text-decoration="underline">www.euskadi.eus</fo:inline>. La aplicación incorpora campos rellenables y autocalculados, como sumas, restas y porcentajes a fin de minimizar errores de cálculo.
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-size="9pt" text-align="justify" width="8cm" padding-start="3pt" padding-end="6pt" padding-before="3pt" padding-after="3pt">
												<fo:block>Behin EKD eginda XML fitxategi bat sortu beharko duzu aplikazioa bera erabilita. XML fitxategia <fo:inline color="#0000FF" text-decoration="underline">www.euskadi.eus</fo:inline> helbidean atondutako esteka baten bitartez bidali beharko da. Horretarako ziurtagiri digital hauetako bat izan beharko duzu: Izenpe, ONA, Diruaren eta Zerga Zigiluaren Fabrika Nazionala (CERES) edo NAN elektronikoa. Txartel-irakurgailu bat ere beharko duzu.
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
												</fo:block>
											</fo:table-cell>
											
											<fo:table-cell font-size="9pt" text-align="justify" width="8cm" padding-start="6pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
												<fo:block>Una vez elaborada la DEC, deberá generar un fichero XML a través de la propia aplicación. El fichero XML se remitirá a través de un enlace habilitado en <fo:inline color="#0000FF" text-decoration="underline">www.euskadi.eus</fo:inline>. Para ello, deberá disponer de alguno de los siguientes certificados digitales: Izenpe, ONA, Fábrica Nacional de Moneda y Timbre (CERES) o el DNI electrónico. Así mismo, será necesario un lector de tarjetas.
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										
										<fo:table-row>
											<fo:table-cell font-size="9pt" text-align="justify" width="8cm" padding-start="3pt" padding-end="6pt" padding-before="3pt" padding-after="3pt">
												<fo:block>Halaber gehitu beharko dituzu, horretarako atondutako esteka erabiliz, indarrean dagoen erantzukizun zibileko polizaren ordain-agiria, ekortuta, eta finantza-erakundeak jaulkitako abala edo kauzio-asegurua (halakorik izanez gero) indarrean dagoela justifikatzen duen agiria.
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
												</fo:block>
											</fo:table-cell>
											
											<fo:table-cell font-size="9pt" text-align="justify" width="8cm" padding-start="6pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
												<fo:block>Así mismo, habrá de adjuntarse escaneado el recibo de la póliza de seguro de responsabilidad civil vigente y el justificante de la vigencia del aval emitido por entidad financiera o de la póliza de un seguro de caución (si procede), a través del enlace establecido al efecto.
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										
										<fo:table-row>
											<fo:table-cell font-size="9pt" text-align="justify" width="8cm" padding-start="3pt" padding-end="6pt" padding-before="3pt" padding-after="3pt">
												<fo:block>Bai aplikazioa deskargatzeko prozesua, bai XML fitxategia betetzeko eta bidaltzekoa, biak ala biak, helbide honetan eskura dagoen "EKD Lantzeko eta Bidaltzeko Gidaliburua" dokumentuan azaltzen dira xehe:
												</fo:block>
											</fo:table-cell>
											
											<fo:table-cell font-size="9pt" text-align="justify" width="8cm" padding-start="6pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
												<fo:block>Tanto el proceso de descarga de la aplicación como la cumplimentación y envío del fichero XML, están explicados en el "Manual de Cumplimentación y envío DEC" disponible en la dirección:
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
								
								
								<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
									<fo:table-column column-width="16cm"/>
									<fo:table-body>
									
										<fo:table-row>
											<fo:table-cell font-size="7.5pt" text-align="justify" width="16cm" padding-start="3pt" padding-end="3pt" padding-before="0pt" padding-after="1pt">
												<fo:block>				
													<fo:inline color="#0000FF" text-decoration="underline">http://www.ogasun.ejgv.euskadi.eus/r51-341/eu/contenidos/canal_telematico/declaracion_estadis_contable/eu_def/servicio_dec.html</fo:inline>		
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										
										<fo:table-row>
											<fo:table-cell font-size="7.5pt" text-align="justify" width="16cm" padding-start="3pt" padding-end="3pt" padding-before="0pt" padding-after="1pt">
												<fo:block>				
													<fo:inline color="#0000FF" text-decoration="underline">http://www.ogasun.ejgv.euskadi.eus/r51-341/es/contenidos/canal_telematico/declaracion_estadis_contable/es_def/servicio_dec.html</fo:inline>		
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									
										<fo:table-row>
											<fo:table-cell font-size="9pt" text-align="right" width="16cm" padding-start="3pt" padding-end="3pt" padding-before="0pt" padding-after="1pt">
												<fo:block>
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
													Vitoria-Gasteiz, 
													<xsl:for-each select="/">
														<xsl:for-each select="cartas">
															<xsl:for-each select="fechaActual">
																<xsl:for-each select="anyo">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>(e)ko 
													<xsl:for-each select="/">
														<xsl:for-each select="cartas">
															<xsl:for-each select="fechaActual">
																<xsl:for-each select="mesEU">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each><xsl:text>&#xA;</xsl:text>
													<xsl:for-each select="/">
														<xsl:for-each select="cartas">
															<xsl:for-each select="fechaActual">
																<xsl:for-each select="dia">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>(a)
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										
										<fo:table-row>
											<fo:table-cell font-size="9pt" text-align="right" width="16cm" padding-start="3pt" padding-end="3pt" padding-before="0pt" padding-after="0pt">
												<fo:block>
													Vitoria-Gasteiz, a <xsl:for-each select="/">
													<xsl:for-each select="cartas">
															<xsl:for-each select="fechaActual">
																<xsl:for-each select="dia">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each> de <xsl:for-each select="/">
														<xsl:for-each select="cartas">
															<xsl:for-each select="fechaActual">
																<xsl:for-each select="mes">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each> de <xsl:for-each select="/">
														<xsl:for-each select="cartas">
															<xsl:for-each select="fechaActual">
																<xsl:for-each select="anyo">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
													
										<fo:table-row>
											<fo:table-cell font-size="9pt" text-align="right" width="16cm" padding-start="3pt" padding-end="3pt" padding-before="0pt" padding-after="1pt">
												<fo:block>
													Finantza Politikako eta Erakundeen Baliabideetako zuzendaria /
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-size="9pt" text-align="right" width="16cm" padding-start="3pt" padding-end="3pt" padding-before="0pt" padding-after="0pt">
												<fo:block>
													La Directora de Política Financiera y Recursos Institucionales
													<fo:block font-size="9pt" color="#000000" text-align="right">
														<fo:external-graphic src="url(/datos/p06b/file/images/firma.gif)" scaling="non-uniform" alignment-adjust="0%" width="3.25cm" height="4cm"/>
													</fo:block>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-size="9pt" text-align="right" width="16cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
												<fo:block>Izpta./Fdo.: Zuriñe Embid Zubiria</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
								<!-- fo:block break-after="page">
									<xsl:text>&#xA;</xsl:text>
								</fo:block-->
							<!-- /xsl:for-each--><!-- mediador -->
						<!-- /xsl:for-each--><!-- cartas -->
					</fo:block>
				</fo:flow><!-- xsl region body -->
			</fo:page-sequence>
		</xsl:for-each><!-- mediador -->
	</xsl:for-each><!-- cartas -->
			
			
			
			
		</fo:root>
	</xsl:template>
</xsl:stylesheet>
